<?php 
$hudson_edge_options = hudson_edge_return_global_options();
$hudson_edge_title_tag = "h5";
if(isset($hudson_edge_options['blog_single_title_tags'])){
    $hudson_edge_title_tag = $hudson_edge_options['blog_single_title_tags'];
}
$hudson_edge_headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
//get correct heading value
$hudson_edge_title_tag = (in_array($hudson_edge_title_tag, $hudson_edge_headings_array)) ? $hudson_edge_title_tag : 'h5';

$hudson_edge_pagination_classes = '';
if( isset($hudson_edge_options['pagination_type']) && $hudson_edge_options['pagination_type'] == 'standard' ) {
	if( isset($hudson_edge_options['pagination_standard_position']) && $hudson_edge_options['pagination_standard_position'] !== '' ) {
		$hudson_edge_pagination_classes .= "standard_".esc_attr($hudson_edge_options['pagination_standard_position']);
	}
}
elseif ( isset($hudson_edge_options['pagination_type']) && $hudson_edge_options['pagination_type'] == 'arrows_on_sides' ) {
	$hudson_edge_pagination_classes .= "arrows_on_sides";
}
?>

<div class="comment_holder clearfix" id="comments">
<div class="comment_number"><div class="comment_number_inner"><<?php echo esc_attr($hudson_edge_title_tag); ?>><?php comments_number( esc_html__('No Comments','hudson'), '1'.esc_html__(' Comment ','hudson'), '% '.esc_html__(' Comments ','hudson')); ?></<?php echo esc_attr($hudson_edge_title_tag); ?>></div></div>
<div class="comments">
<?php if ( post_password_required() ) : ?>
				<p class="nopassword"><?php esc_html_e( 'This post is password protected. Enter the password to view any comments.', 'hudson' ); ?></p>
			</div></div>
<?php
		
		return;
	endif;
?>
<?php if ( have_comments() ) : ?>

	<ul class="comment-list <?php if(isset($hudson_edge_options['blog_comments_reply_link_on_bottom_yes_no'])&& $hudson_edge_options['blog_comments_reply_link_on_bottom_yes_no']=='yes' ) echo "bottom-comment-link" ;?>">
		<?php wp_list_comments(array( 'callback' => 'hudson_edge_comment')); ?>
	</ul>


<?php // End Comments ?>

 <?php else : // this is displayed if there are no comments so far 

	if ( ! comments_open() ) :
?>
		<!-- If comments are open, but there are no comments. -->

	 
		<!-- If comments are closed. -->
		<p><?php esc_html_e('Sorry, the comment form is closed at this time.', 'hudson'); ?></p>

	<?php endif; ?>
<?php endif; ?>
</div></div>
<?php
$hudson_edge_commenter = wp_get_current_commenter();
$hudson_edge_req = get_option( 'require_name_email' );
$hudson_edge_aria_req = ( $hudson_edge_req ? " aria-required='true'" : '' );
$hudson_edge_consent  = empty( $hudson_edge_commenter['comment_author_email'] ) ? '' : ' checked="checked"';

$hudson_edge_args = array(
	'id_form' => 'commentform',
	'id_submit' => 'submit_comment',
	'title_reply'=>'<'.$hudson_edge_title_tag.'>'. esc_html__( 'Post a Comment','hudson' ) .'</'.$hudson_edge_title_tag.'>',
	'title_reply_to' => esc_html__( 'Post a Reply to %s','hudson' ),
	'cancel_reply_link' => esc_html__( 'Cancel Reply','hudson' ),
	'label_submit' => esc_html__( 'Submit','hudson' ),
	'comment_field' => '<textarea id="comment" placeholder="'.esc_html__( 'Write your comment here...','hudson' ).'" name="comment" cols="45" rows="8" aria-required="true"></textarea>',
	'comment_notes_before' => '',
	'comment_notes_after' => '',
	'fields' => apply_filters( 'comment_form_default_fields', array(
		'author' => '<div class="three_columns clearfix"><div class="column1"><div class="column_inner"><input id="author" name="author" placeholder="'. esc_html__( 'Your full name','hudson' ) .'" type="text" value="' . esc_attr( $hudson_edge_commenter['comment_author'] ) . '"' . $hudson_edge_aria_req . ' /></div></div>',
		'url' => '<div class="column2"><div class="column_inner"><input id="email" name="email" placeholder="'. esc_html__( 'E-mail address','hudson' ) .'" type="text" value="' . esc_attr(  $hudson_edge_commenter['comment_author_email'] ) . '"' . $hudson_edge_aria_req . ' /></div></div>',
		'email' => '<div class="column3"><div class="column_inner"><input id="url" name="url" type="text" placeholder="'. esc_html__( 'Website','hudson' ) .'" value="' . esc_attr( $hudson_edge_commenter['comment_author_url'] ) . '" /></div></div></div>',
        'cookies' => '<p class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes" ' . $hudson_edge_consent . ' />' .
            '<label for="wp-comment-cookies-consent">' . esc_html__( 'Save my name, email, and website in this browser for the next time I comment.', 'hudson' ) . '</label></p>'
        ) ) );
 ?>
<?php if(get_comment_pages_count() > 1){
	?>
	<div class="comment_pager <?php echo esc_attr($hudson_edge_pagination_classes); ?>">
		<p><?php paginate_comments_links(); ?></p>
	</div>
<?php } ?>
 <div class="comment_form">
	<?php comment_form($hudson_edge_args); ?>
</div>
								
							


